<?php
/**
 * Report PPN Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_ppn extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function income()
 	{	
        $data['content_title'] = 'Laporan PPN - Masukan';
		
		$this->twiggy_display('adm/report_ppn/income', $data);
	}

	public function outcome()
 	{	
        $data['content_title'] = 'Laporan PPN - Keluaran';
		
		$this->twiggy_display('adm/report_ppn/outcome', $data);
	}

	public function get_data_detail()
	{	
		// Set timezone
		date_default_timezone_set('Asia/Jakarta');
		$data = [];

		// $date_1 = '2021-01-24';
		// $date_2 = '2021-02-17';

		$date_1 = $this->input->post("date_1");
		$date_2 = $this->input->post("date_2");
		$date_3 = date('Y-m-d', strtotime($date_2. '+1 day'));
		
		$total_in  = 0;
		$total_out = 0;

		$daterange = new DatePeriod(new DateTime($date_1), new DateInterval('P1D'), new DateTime($date_3));
		
		$no = 1;
		foreach($daterange as $date){
			$where_so = array('sales_order_header_date' => $date->format("Y-m-d"));
			$where_po = array('purchase_order_header_date' => $date->format("Y-m-d"));

			$in  = $this->Reports_model->get_soheader('COALESCE(SUM(sales_order_header_ppn_total),0) as total', $where_so)->row()->total;
			$out = $this->Reports_model->get_poheader('COALESCE(SUM(purchase_order_header_ppn_total),0) as total', $where_po)->row()->total;
			$data[] = array(
				'no'   => $no,
				'date' => $date->format("d/m/Y"),
				'in'   => number_format($in),
				'out'  => number_format($out)
			);

			$total_in  += $in;
			$total_out += $out;
			$no++;
		}

		$response = [
			'data'      => $data,
			'date_1'    => ($date_1 == '' ? change_format_date(date_now(), 'd/m/Y') : change_format_date($date_1, 'd/m/Y')),
			'date_2'    => ($date_2 == '' ? change_format_date(date_now(), 'd/m/Y') : change_format_date($date_2, 'd/m/Y')),
			'total_in'  => number_format($total_in),
			'total_out' => number_format($total_out)
		];

		output_json($response);

	}

	public function export_excel() {

		$supplier = $this->session->userdata('supplier');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order    = ("purchase_order_header_number ASC");
		$supplier_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($supplier) && $supplier != '' && $supplier != '(Semua)')
		{
			$where['purchase_order_header_supplier_id'] = $supplier;
			$supplier_name = $this->Suppliers_model->get_data(array('supplier_id' => $supplier))->row()->supplier_name;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['purchase_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['purchase_order_header_date <='] = change_format_date($todate);
		}

		$where['status_paid'] = 0;
		
		$get_data = $this->Purchase_orders_model->purchaseorder_header($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("HUTANG")
							   ->setSubject("HUTANG")
							   ->setDescription("HUTANG")
							   ->setKeywords("HUTANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Hutang");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$supplier_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$fromdate_text." - ".$todate_text);

	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Nomor Pembelian");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "Jatuh Tempo");
	    $excel->setActiveSheetIndex(0)->setCellValue('D6', "Supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Total");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D6')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E6')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$where        = array('purchase_order_header_id' => $get_row->purchase_order_header_id);
			$return_total = 0;
			$return_data  = $this->Purchase_returns_model->purchasereturn_header($where)->row();
			if($return_data){
				$return_total = $return_data->purchase_return_header_grand_total;
			}
			$total = ($get_row->purchase_order_header_grand_total - $return_total);

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->purchase_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->purchase_order_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, change_format_date($get_row->purchase_order_header_payment_due, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->supplier_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, number_format($total));

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('E'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("HUTANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'HUTANG_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
